from fastapi import APIRouter, Depends
from datetime import datetime
from typing import Optional

from app.db import database
from app.v1.models.platform.iotdevices import (
    IotDevice, IotDeviceCreate, IotDeviceUpdate, IotDeviceList
)
from app.v1.services.platform.iotdevices import (
    create_iot_device_service, get_iot_device_service,
    update_iot_device_service, delete_iot_device_service,
    list_iot_devices_service
)

router = APIRouter()

@router.post("/", response_model=IotDevice)
async def create_iot_device(device: IotDeviceCreate, db=Depends(database.get_mongo_db)):
    print("create_iot_devicecreate_iot_devicecreate_iot_device")
    return await create_iot_device_service(device, db)

@router.get("/", response_model=IotDeviceList)
async def list_iot_devices(skip: int = 0, limit: int = 10, db=Depends(database.get_mongo_db)):
    return await list_iot_devices_service(skip, limit, db)

@router.get("/{account_id}", response_model=IotDevice)
async def get_iot_device(account_id: str, db=Depends(database.get_mongo_db)):
    return await get_iot_device_service(account_id, db)

@router.post("/{account_id}", response_model=IotDevice)
async def post_iot_device(account_id: str, device: IotDeviceCreate, db=Depends(database.get_mongo_db)):
    return await create_iot_device_service(device, db)

@router.put("/{account_id}", response_model=IotDevice)
async def update_iot_device(account_id: str, update: IotDeviceUpdate, db=Depends(database.get_mongo_db)):
    return await update_iot_device_service(account_id, update, db)

@router.delete("/{account_id}", response_model=IotDevice)
async def delete_iot_device(account_id: str, db=Depends(database.get_mongo_db)):
    return await delete_iot_device_service(account_id, db)
